-- A customization script is intended to be used to customize a scene in
-- various ways, mainly when simulation is not running. When simulation is running,
-- do not use customization scripts, but rather child scripts if possible
--
-- if you wish to execute code contained in an external file,
-- use the require-directive, e.g.:
--
-- require 'myExternalFile'
--
-- Above will look for <CoppeliaSim executable path>/myExternalFile.lua or
-- <CoppeliaSim executable path>/lua/myExternalFile.lua
-- (the file can be opened in this editor with the popup menu over
-- the file name)
--
--
-- Make sure you read the section on "Accessing general-type objects programmatically"
-- For instance, if you wish to retrieve the handle of a scene object, use following instruction:
--
-- handle=sim.getObjectHandle('sceneObjectName')
-- 
-- Above instruction retrieves the handle of 'sceneObjectName' if this script's name has no '#' in it
--
-- If this script's name contains a '#' (e.g. 'someName#4'), then above instruction retrieves the handle of object 'sceneObjectName#4'
-- This mechanism of handle retrieval is very convenient, since you don't need to adjust any code when a model is duplicated!
-- So if the script's name (or rather the name of the object associated with this script) is:
--
-- 'someName', then the handle of 'sceneObjectName' is retrieved
-- 'someName#0', then the handle of 'sceneObjectName#0' is retrieved
-- 'someName#1', then the handle of 'sceneObjectName#1' is retrieved
-- ...
--
-- If you always want to retrieve the same object's handle, no matter what, specify its full name, including a '#':
--
-- handle=sim.getObjectHandle('sceneObjectName#') always retrieves the handle of object 'sceneObjectName' 
-- handle=sim.getObjectHandle('sceneObjectName#0') always retrieves the handle of object 'sceneObjectName#0' 
-- handle=sim.getObjectHandle('sceneObjectName#1') always retrieves the handle of object 'sceneObjectName#1'
-- ...
--
-- Refer to the user manual and the code snippets, for additional details and infos about
-- available callback functions

